<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyCreatorRequest;
use App\Http\Requests\StoreCreatorRequest;
use App\Http\Requests\UpdateCreatorRequest;
use App\Models\Creator;
use App\Models\ModelType;
use App\Models\Platform;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CreatorsController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('creator_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $creators = Creator::with(['typeofmodels', 'platform'])->get();

        return view('admin.creators.index', compact('creators'));
    }

    public function create()
    {
        abort_if(Gate::denies('creator_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $typeofmodels = ModelType::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $platforms = Platform::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        return view('admin.creators.create', compact('platforms', 'typeofmodels'));
    }

    public function store(StoreCreatorRequest $request)
    {
        $creator = Creator::create($request->all());

        return redirect()->route('admin.creators.index');
    }

    public function edit(Creator $creator)
    {
        abort_if(Gate::denies('creator_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $typeofmodels = ModelType::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $platforms = Platform::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $creator->load('typeofmodels', 'platform');

        return view('admin.creators.edit', compact('creator', 'platforms', 'typeofmodels'));
    }

    public function update(UpdateCreatorRequest $request, Creator $creator)
    {
        $creator->update($request->all());

        return redirect()->route('admin.creators.index');
    }

    public function show(Creator $creator)
    {
        abort_if(Gate::denies('creator_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $creator->load('typeofmodels', 'platform');

        return view('admin.creators.show', compact('creator'));
    }

    public function destroy(Creator $creator)
    {
        abort_if(Gate::denies('creator_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $creator->delete();

        return back();
    }

    public function massDestroy(MassDestroyCreatorRequest $request)
    {
        $creators = Creator::find(request('ids'));

        foreach ($creators as $creator) {
            $creator->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
