<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyProducttypeRequest;
use App\Http\Requests\StoreProducttypeRequest;
use App\Http\Requests\UpdateProducttypeRequest;
use App\Models\Producttype;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Yajra\DataTables\Facades\DataTables;

class ProducttypesController extends Controller
{
    public function index(Request $request)
    {
        abort_if(Gate::denies('producttype_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->ajax()) {
            $query = Producttype::query()->select(sprintf('%s.*', (new Producttype)->table));
            $table = Datatables::of($query);

            $table->addColumn('placeholder', '&nbsp;');
            $table->addColumn('actions', '&nbsp;');

            $table->editColumn('actions', function ($row) {
                $viewGate      = 'producttype_show';
                $editGate      = 'producttype_edit';
                $deleteGate    = 'producttype_delete';
                $crudRoutePart = 'producttypes';

                return view('partials.datatablesActions', compact(
                    'viewGate',
                    'editGate',
                    'deleteGate',
                    'crudRoutePart',
                    'row'
                ));
            });

            $table->editColumn('id', function ($row) {
                return $row->id ? $row->id : '';
            });
            $table->editColumn('name', function ($row) {
                return $row->name ? $row->name : '';
            });

            $table->rawColumns(['actions', 'placeholder']);

            return $table->make(true);
        }

        return view('admin.producttypes.index');
    }

    public function create()
    {
        abort_if(Gate::denies('producttype_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.producttypes.create');
    }

    public function store(StoreProducttypeRequest $request)
    {
        $producttype = Producttype::create($request->all());

        return redirect()->route('admin.producttypes.index');
    }

    public function edit(Producttype $producttype)
    {
        abort_if(Gate::denies('producttype_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.producttypes.edit', compact('producttype'));
    }

    public function update(UpdateProducttypeRequest $request, Producttype $producttype)
    {
        $producttype->update($request->all());

        return redirect()->route('admin.producttypes.index');
    }

    public function show(Producttype $producttype)
    {
        abort_if(Gate::denies('producttype_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.producttypes.show', compact('producttype'));
    }

    public function destroy(Producttype $producttype)
    {
        abort_if(Gate::denies('producttype_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $producttype->delete();

        return back();
    }

    public function massDestroy(MassDestroyProducttypeRequest $request)
    {
        $producttypes = Producttype::find(request('ids'));

        foreach ($producttypes as $producttype) {
            $producttype->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
