<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreIdeaRequest;
use App\Http\Requests\UpdateIdeaRequest;
use App\Http\Resources\Admin\IdeaResource;
use App\Models\Idea;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IdeasApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('idea_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new IdeaResource(Idea::with(['productline'])->get());
    }

    public function store(StoreIdeaRequest $request)
    {
        $idea = Idea::create($request->all());

        return (new IdeaResource($idea))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(Idea $idea)
    {
        abort_if(Gate::denies('idea_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new IdeaResource($idea->load(['productline']));
    }

    public function update(UpdateIdeaRequest $request, Idea $idea)
    {
        $idea->update($request->all());

        return (new IdeaResource($idea))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(Idea $idea)
    {
        abort_if(Gate::denies('idea_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $idea->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
