<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StorePrintfarmplanRequest;
use App\Http\Requests\UpdatePrintfarmplanRequest;
use App\Http\Resources\Admin\PrintfarmplanResource;
use App\Models\Printfarmplan;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class PrintfarmplanApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('printfarmplan_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new PrintfarmplanResource(Printfarmplan::with(['productline', 'creator'])->get());
    }

    public function store(StorePrintfarmplanRequest $request)
    {
        $printfarmplan = Printfarmplan::create($request->all());

        return (new PrintfarmplanResource($printfarmplan))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(Printfarmplan $printfarmplan)
    {
        abort_if(Gate::denies('printfarmplan_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new PrintfarmplanResource($printfarmplan->load(['productline', 'creator']));
    }

    public function update(UpdatePrintfarmplanRequest $request, Printfarmplan $printfarmplan)
    {
        $printfarmplan->update($request->all());

        return (new PrintfarmplanResource($printfarmplan))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(Printfarmplan $printfarmplan)
    {
        abort_if(Gate::denies('printfarmplan_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $printfarmplan->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
