<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreProducttypeRequest;
use App\Http\Requests\UpdateProducttypeRequest;
use App\Http\Resources\Admin\ProducttypeResource;
use App\Models\Producttype;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ProducttypesApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('producttype_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new ProducttypeResource(Producttype::all());
    }

    public function store(StoreProducttypeRequest $request)
    {
        $producttype = Producttype::create($request->all());

        return (new ProducttypeResource($producttype))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(Producttype $producttype)
    {
        abort_if(Gate::denies('producttype_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new ProducttypeResource($producttype);
    }

    public function update(UpdateProducttypeRequest $request, Producttype $producttype)
    {
        $producttype->update($request->all());

        return (new ProducttypeResource($producttype))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(Producttype $producttype)
    {
        abort_if(Gate::denies('producttype_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $producttype->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
