<?php

namespace App\Http\Requests;

use App\Models\ModelType;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroyModelTypeRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('model_type_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:model_types,id',
        ];
    }
}
