<?php

namespace App\Http\Requests;

use App\Models\Creator;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreCreatorRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('creator_create');
    }

    public function rules()
    {
        return [
            'name' => [
                'string',
                'required',
            ],
            'typeofmodels_id' => [
                'required',
                'integer',
            ],
            'platform_id' => [
                'required',
                'integer',
            ],
            'link' => [
                'string',
                'required',
            ],
            'subscribed' => [
                'required',
            ],
        ];
    }
}
