<?php

namespace App\Http\Requests;

use App\Models\Eventslog;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreEventslogRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('eventslog_create');
    }

    public function rules()
    {
        return [
            'eventname_id' => [
                'required',
                'integer',
            ],
            'cashtakings' => [
                'required',
            ],
            'cardtakings' => [
                'required',
            ],
        ];
    }
}
