<?php

namespace App\Http\Requests;

use App\Models\Idea;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreIdeaRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('idea_create');
    }

    public function rules()
    {
        return [
            'name' => [
                'string',
                'required',
            ],
            'productline_id' => [
                'required',
                'integer',
            ],
            'link' => [
                'string',
                'required',
            ],
            'added' => [
                'required',
            ],
        ];
    }
}
