<?php

namespace App\Http\Requests;

use App\Models\Printfarmplan;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StorePrintfarmplanRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('printfarmplan_create');
    }

    public function rules()
    {
        return [
            'name' => [
                'string',
                'required',
            ],
            'productline_id' => [
                'required',
                'integer',
            ],
            'creator_id' => [
                'required',
                'integer',
            ],
        ];
    }
}
