<?php

namespace App\Http\Requests;

use App\Models\Event;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateEventRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('event_edit');
    }

    public function rules()
    {
        return [
            'eventname' => [
                'string',
                'required',
            ],
            'date' => [
                'required',
                'date_format:' . config('panel.date_format'),
            ],
            'setuptime' => [
                'required',
                'date_format:' . config('panel.time_format'),
            ],
            'starttime' => [
                'required',
                'date_format:' . config('panel.time_format'),
            ],
            'packuptime' => [
                'required',
                'date_format:' . config('panel.time_format'),
            ],
            'address' => [
                'required',
            ],
            'eventscompany_id' => [
                'required',
                'integer',
            ],
            'cost' => [
                'required',
            ],
        ];
    }
}
