<?php

namespace App\Models;

use Carbon\Carbon;
use DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model
{
    use SoftDeletes, HasFactory;

    public $table = 'events';

    protected $dates = [
        'date',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public const GAZEBO_RADIO = [
        'FullSetupGazebo' => 'Gazebo With Tables',
        'TablesOnly'      => 'Tables Only',
    ];

    protected $fillable = [
        'eventname',
        'date',
        'setuptime',
        'starttime',
        'packuptime',
        'address',
        'eventscompany_id',
        'eventscontact_id',
        'cost',
        'gazebo',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function getDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('panel.date_format')) : null;
    }

    public function setDateAttribute($value)
    {
        $this->attributes['date'] = $value ? Carbon::createFromFormat(config('panel.date_format'), $value)->format('Y-m-d') : null;
    }

    public function eventscompany()
    {
        return $this->belongsTo(ContactCompany::class, 'eventscompany_id');
    }

    public function eventscontact()
    {
        return $this->belongsTo(ContactContact::class, 'eventscontact_id');
    }
}
