<?php

namespace App\Models;

use DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Printfarmplan extends Model
{
    use SoftDeletes, HasFactory;

    public $table = 'printfarmplans';

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'name',
        'productline_id',
        'creator_id',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function productline()
    {
        return $this->belongsTo(Producttype::class, 'productline_id');
    }

    public function creator()
    {
        return $this->belongsTo(Creator::class, 'creator_id');
    }
}
