@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.creator.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.creators.update", [$creator->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label class="required" for="name">{{ trans('cruds.creator.fields.name') }}</label>
                <input class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" type="text" name="name" id="name" value="{{ old('name', $creator->name) }}" required>
                @if($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.creator.fields.name_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="typeofmodels_id">{{ trans('cruds.creator.fields.typeofmodels') }}</label>
                <select class="form-control select2 {{ $errors->has('typeofmodels') ? 'is-invalid' : '' }}" name="typeofmodels_id" id="typeofmodels_id" required>
                    @foreach($typeofmodels as $id => $entry)
                        <option value="{{ $id }}" {{ (old('typeofmodels_id') ? old('typeofmodels_id') : $creator->typeofmodels->id ?? '') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('typeofmodels'))
                    <span class="text-danger">{{ $errors->first('typeofmodels') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.creator.fields.typeofmodels_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="platform_id">{{ trans('cruds.creator.fields.platform') }}</label>
                <select class="form-control select2 {{ $errors->has('platform') ? 'is-invalid' : '' }}" name="platform_id" id="platform_id" required>
                    @foreach($platforms as $id => $entry)
                        <option value="{{ $id }}" {{ (old('platform_id') ? old('platform_id') : $creator->platform->id ?? '') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('platform'))
                    <span class="text-danger">{{ $errors->first('platform') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.creator.fields.platform_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="link">{{ trans('cruds.creator.fields.link') }}</label>
                <input class="form-control {{ $errors->has('link') ? 'is-invalid' : '' }}" type="text" name="link" id="link" value="{{ old('link', $creator->link) }}" required>
                @if($errors->has('link'))
                    <span class="text-danger">{{ $errors->first('link') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.creator.fields.link_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required">{{ trans('cruds.creator.fields.subscribed') }}</label>
                <select class="form-control {{ $errors->has('subscribed') ? 'is-invalid' : '' }}" name="subscribed" id="subscribed" required>
                    <option value disabled {{ old('subscribed', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\Creator::SUBSCRIBED_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('subscribed', $creator->subscribed) === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('subscribed'))
                    <span class="text-danger">{{ $errors->first('subscribed') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.creator.fields.subscribed_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection