@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.creator.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.creators.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.creator.fields.id') }}
                        </th>
                        <td>
                            {{ $creator->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.creator.fields.name') }}
                        </th>
                        <td>
                            {{ $creator->name }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.creator.fields.typeofmodels') }}
                        </th>
                        <td>
                            {{ $creator->typeofmodels->name ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.creator.fields.platform') }}
                        </th>
                        <td>
                            {{ $creator->platform->name ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.creator.fields.link') }}
                        </th>
                        <td>
                            {{ $creator->link }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.creator.fields.subscribed') }}
                        </th>
                        <td>
                            {{ App\Models\Creator::SUBSCRIBED_SELECT[$creator->subscribed] ?? '' }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.creators.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>



@endsection