@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.create') }} {{ trans('cruds.event.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.events.store") }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label class="required" for="eventname">{{ trans('cruds.event.fields.eventname') }}</label>
                <input class="form-control {{ $errors->has('eventname') ? 'is-invalid' : '' }}" type="text" name="eventname" id="eventname" value="{{ old('eventname', '') }}" required>
                @if($errors->has('eventname'))
                    <span class="text-danger">{{ $errors->first('eventname') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.event.fields.eventname_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="date">{{ trans('cruds.event.fields.date') }}</label>
                <input class="form-control date {{ $errors->has('date') ? 'is-invalid' : '' }}" type="text" name="date" id="date" value="{{ old('date') }}" required>
                @if($errors->has('date'))
                    <span class="text-danger">{{ $errors->first('date') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.event.fields.date_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="setuptime">{{ trans('cruds.event.fields.setuptime') }}</label>
                <input class="form-control timepicker {{ $errors->has('setuptime') ? 'is-invalid' : '' }}" type="text" name="setuptime" id="setuptime" value="{{ old('setuptime') }}" required>
                @if($errors->has('setuptime'))
                    <span class="text-danger">{{ $errors->first('setuptime') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.event.fields.setuptime_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="starttime">{{ trans('cruds.event.fields.starttime') }}</label>
                <input class="form-control timepicker {{ $errors->has('starttime') ? 'is-invalid' : '' }}" type="text" name="starttime" id="starttime" value="{{ old('starttime') }}" required>
                @if($errors->has('starttime'))
                    <span class="text-danger">{{ $errors->first('starttime') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.event.fields.starttime_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="packuptime">{{ trans('cruds.event.fields.packuptime') }}</label>
                <input class="form-control timepicker {{ $errors->has('packuptime') ? 'is-invalid' : '' }}" type="text" name="packuptime" id="packuptime" value="{{ old('packuptime') }}" required>
                @if($errors->has('packuptime'))
                    <span class="text-danger">{{ $errors->first('packuptime') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.event.fields.packuptime_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="address">{{ trans('cruds.event.fields.address') }}</label>
                <textarea class="form-control {{ $errors->has('address') ? 'is-invalid' : '' }}" name="address" id="address" required>{{ old('address') }}</textarea>
                @if($errors->has('address'))
                    <span class="text-danger">{{ $errors->first('address') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.event.fields.address_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="eventscompany_id">{{ trans('cruds.event.fields.eventscompany') }}</label>
                <select class="form-control select2 {{ $errors->has('eventscompany') ? 'is-invalid' : '' }}" name="eventscompany_id" id="eventscompany_id" required>
                    @foreach($eventscompanies as $id => $entry)
                        <option value="{{ $id }}" {{ old('eventscompany_id') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('eventscompany'))
                    <span class="text-danger">{{ $errors->first('eventscompany') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.event.fields.eventscompany_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="eventscontact_id">{{ trans('cruds.event.fields.eventscontact') }}</label>
                <select class="form-control select2 {{ $errors->has('eventscontact') ? 'is-invalid' : '' }}" name="eventscontact_id" id="eventscontact_id">
                    @foreach($eventscontacts as $id => $entry)
                        <option value="{{ $id }}" {{ old('eventscontact_id') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('eventscontact'))
                    <span class="text-danger">{{ $errors->first('eventscontact') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.event.fields.eventscontact_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="cost">{{ trans('cruds.event.fields.cost') }}</label>
                <input class="form-control {{ $errors->has('cost') ? 'is-invalid' : '' }}" type="number" name="cost" id="cost" value="{{ old('cost', '') }}" step="0.01" required>
                @if($errors->has('cost'))
                    <span class="text-danger">{{ $errors->first('cost') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.event.fields.cost_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.event.fields.gazebo') }}</label>
                @foreach(App\Models\Event::GAZEBO_RADIO as $key => $label)
                    <div class="form-check {{ $errors->has('gazebo') ? 'is-invalid' : '' }}">
                        <input class="form-check-input" type="radio" id="gazebo_{{ $key }}" name="gazebo" value="{{ $key }}" {{ old('gazebo', '') === (string) $key ? 'checked' : '' }}>
                        <label class="form-check-label" for="gazebo_{{ $key }}">{{ $label }}</label>
                    </div>
                @endforeach
                @if($errors->has('gazebo'))
                    <span class="text-danger">{{ $errors->first('gazebo') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.event.fields.gazebo_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection