@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.create') }} {{ trans('cruds.eventslog.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.eventslogs.store") }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label class="required" for="eventname_id">{{ trans('cruds.eventslog.fields.eventname') }}</label>
                <select class="form-control select2 {{ $errors->has('eventname') ? 'is-invalid' : '' }}" name="eventname_id" id="eventname_id" required>
                    @foreach($eventnames as $id => $entry)
                        <option value="{{ $id }}" {{ old('eventname_id') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('eventname'))
                    <span class="text-danger">{{ $errors->first('eventname') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.eventslog.fields.eventname_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="cashtakings">{{ trans('cruds.eventslog.fields.cashtakings') }}</label>
                <input class="form-control {{ $errors->has('cashtakings') ? 'is-invalid' : '' }}" type="number" name="cashtakings" id="cashtakings" value="{{ old('cashtakings', '') }}" step="0.01" required>
                @if($errors->has('cashtakings'))
                    <span class="text-danger">{{ $errors->first('cashtakings') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.eventslog.fields.cashtakings_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="cardtakings">{{ trans('cruds.eventslog.fields.cardtakings') }}</label>
                <input class="form-control {{ $errors->has('cardtakings') ? 'is-invalid' : '' }}" type="number" name="cardtakings" id="cardtakings" value="{{ old('cardtakings', '') }}" step="0.01" required>
                @if($errors->has('cardtakings'))
                    <span class="text-danger">{{ $errors->first('cardtakings') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.eventslog.fields.cardtakings_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection