@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.eventslog.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.eventslogs.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.eventslog.fields.id') }}
                        </th>
                        <td>
                            {{ $eventslog->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.eventslog.fields.eventname') }}
                        </th>
                        <td>
                            {{ $eventslog->eventname->eventname ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.eventslog.fields.cashtakings') }}
                        </th>
                        <td>
                            {{ $eventslog->cashtakings }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.eventslog.fields.cardtakings') }}
                        </th>
                        <td>
                            {{ $eventslog->cardtakings }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.eventslogs.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>



@endsection