@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.printfarmplan.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.printfarmplans.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.printfarmplan.fields.id') }}
                        </th>
                        <td>
                            {{ $printfarmplan->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.printfarmplan.fields.name') }}
                        </th>
                        <td>
                            {{ $printfarmplan->name }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.printfarmplan.fields.productline') }}
                        </th>
                        <td>
                            {{ $printfarmplan->productline->name ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.printfarmplan.fields.creator') }}
                        </th>
                        <td>
                            {{ $printfarmplan->creator->name ?? '' }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.printfarmplans.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>



@endsection